var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import createDefaultPack from "./create-default-pack.js";
import createDefaultPackJson from "./packs/create-default-json.js";
import PACKS_CONFIG, { DefaultCategorySettings } from "./packs/packs-config.js";
const packs = [
    PACKS_CONFIG["Settings in SubCategory"].packFromDatabase,
    PACKS_CONFIG["Links"].packFromDatabase,
    PACKS_CONFIG["Preview fix"].packFromDatabase,
    PACKS_CONFIG[DefaultCategorySettings].packFromDatabase,
    // PACKS_CONFIG[VideoWithThumbnails].packFromDatabase,
    // PACKS_CONFIG["Many Categories"].packFromDatabase,
    PACKS_CONFIG["SFX compatible"].packFromDatabase,
    PACKS_CONFIG["SFX compatible 2"].packFromDatabase,
    // PACKS_CONFIG["SFX default Emerald"].packFromDatabase,
    PACKS_CONFIG["Sound pack"].packFromDatabase,
    PACKS_CONFIG["Settings on Pack Level"].packFromDatabase,
    PACKS_CONFIG["Settings on Pack Level 2"].packFromDatabase,
];
const ALL_PACKS = packs.map(pack => createDefaultPack(pack));
function getPacks() {
    return __awaiter(this, void 0, void 0, function* () {
        return ALL_PACKS;
    });
}
window.getPacks = getPacks;
window.getHost = () => "PPRO";
window.getPluginVersion = () => "4.0.0";
function getPreset(path) {
    const pack = ALL_PACKS.find(pack => pack.path === path);
    if (!pack)
        throw new Error(`Pack with path ${path} not found`);
    const candidate = PACKS_CONFIG[pack.name];
    if (candidate) {
        return createDefaultPackJson(pack, candidate.categories, candidate.packFromDatabase.settings, candidate.packFromDatabase.origin, candidate.packFromDatabase.markers);
    }
    return createDefaultPackJson(pack);
}
window.getPreset = getPreset;
function applyVideo(arg) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(arg);
        const isError = false;
        if (isError) {
            setTimeout(() => {
                window.dispatchEvent(new CustomEvent('errorInUpload', {
                    detail: { text: "Error in upload" }
                }));
            }, 1000);
        }
        else {
            setTimeout(() => {
                window.dispatchEvent(new CustomEvent('successInUpload', {
                    detail: { text: "Event Successfully Uploaded" }
                }));
            }, 1000);
        }
    });
}
window.applyVideo = applyVideo;
function vPr(packName, packAuthor, path, packFolderName, origin) {
    return __awaiter(this, void 0, void 0, function* () {
        const isError = false;
        return !isError;
    });
}
window.vPr = vPr;
function getSeparator() {
    return "\\";
}
window.getSeparator = getSeparator;
function onClickOpenUrlInDefaultBrowser(url) {
    window.open(url, '_blank');
}
window.onClickOpenUrlInDefaultBrowser = onClickOpenUrlInDefaultBrowser;
function installPack(file) {
    return __awaiter(this, void 0, void 0, function* () {
        // Симуляция проверки существования пакета
        const packExists = false; // Здесь можно добавить реальную логику проверки
        if (packExists) {
            const packExisted = {
                status: "exists",
                packExistedPath: "D:\\temp\\MotionBro\\SFX compatible_by_Videolancer",
                currentVersion: "1.0.0",
                newVersion: "1.0.0",
                packPath: "D:\\temp\\MotionBro\\SFX compatible_by_Videolancer",
                archiveName: "SFX compatible_by_Videolancer",
                packActualName: "SFX compatible",
                message: "Pack is already installed."
            };
            return packExisted; // Немедленный возврат, если пакет уже существует
        }
        // Если пакет не существует, симулируем установку с задержкой 15 секунд
        return new Promise((resolve) => {
            setTimeout(() => {
                const packInstallSuccess = {
                    status: "success",
                    message: "Pack has been installed",
                    info: {
                        packName: "Many Categories",
                        version: "1.0.0",
                        author: "Videolancer",
                        packFolderName: "Many Categories_by_Videolancer",
                        origin: undefined,
                    },
                    needVerification: true
                };
                resolve(packInstallSuccess);
            }, 15000); // Задержка 15 секунд
        });
    });
}
// Экспонирование функции для глобального доступа (например, для тестирования)
window.installPack = installPack;
function uninstallPack(packFolderName) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            status: "success",
            message: "Pack has been uninstalled"
        };
    });
}
window.uninstallPack = uninstallPack;
function rJB(packFolderName, host) {
    return __awaiter(this, void 0, void 0, function* () {
        return "jsxbinString";
    });
}
window.rJB = rJB;
function eJB(jsxbinString) {
}
window.eJB = eJB;
function getInstallationPath() {
    return Promise.resolve("D:\\temp\\MotionBro");
}
window.getInstallationPath = getInstallationPath;
